#include <bits/stdc++.h>
#include <vector>
using namespace std;

bool contains(vector<int> values, int val) {
    for(int v : values) {
        if(v == val) return true;
    }
    return false;
}
bool contains1(vector<tuple<int,int,int>> values, tuple<int,int,int> val) {
    for(const auto& v : values) {
        if(v == val) return true;
    }
    return false;
}

int getLowPricest(vector<tuple<int,int,int>> links) {
    uint64_t minimal = UINT64_MAX;
    int ind = 0;
    for(int i = 0; i < links.size(); i++) {
        auto& d = links[i];
        int V = get<0>(d);
        int U = get<1>(d);
        int T = get<2>(d);
        if(T < minimal) {
            minimal = T;
            ind = i;
        }
    }
    return ind;
}

int BFS(vector<int> prices, vector<tuple<int,int,int>> links, int A, int B) {
    int prevSystem = 0;
    int price = 0;
    vector<int> queue;
    vector<int> visited;
    queue.push_back(A);
    vector<tuple<int,int,int>> v_links;
    vector<tuple<int,int,int>> ig;

    bool onTarget = false;
    while(true) {
        bool found = false;
        for(const auto& d : links) {
            if(contains1(ig,d)) continue;
            int V = get<0>(d);
            int U = get<1>(d);
            int T = get<2>(d);
            if(contains(queue,V) && !contains(visited,U)) {
                if(!contains(visited,V)) visited.push_back(V);
                if(T == prevSystem) {
                    // Prefer same system rather than different one
                    queue.push_back(U);
                    ig.push_back(d);
                    if(U == B) {
                        onTarget = true;
                        break;
                    }
                    found = true;
                    break;
                } else {
                    v_links.push_back(d);
                }
            }
            if(contains(queue,U) && !contains(visited,V)) {
                if(!contains(visited,U)) visited.push_back(U);
                if(T == prevSystem) {
                    // Prefer same system rather than different one
                    queue.push_back(V);
                    ig.push_back(d);
                    if(V == B) {
                        onTarget = true;
                        break;
                    }
                    found = true;
                    break;
                } else {
                    v_links.push_back(d);
                }
            }
        }
        if(onTarget) break;
        if(!found) {
            int ind = getLowPricest(v_links);
            auto d = v_links[ind];
            int V = get<0>(d);
            int U = get<1>(d);
            int T = get<2>(d);
            if(!contains(visited,U)) queue.push_back(U);
            if(!contains(visited,V)) queue.push_back(V);
            prevSystem = T;
            price += prices[T-1];
            ig.push_back(d);
        }

        v_links.clear();
    }

    return price;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    
    int N; // station count
    int M; // links count
    int K; // systems count

    cin >> N;
    cin >> M;
    cin >> K;

    vector<int> prices;

    for(int i = 0; i < K; i++) {
        int P;
        cin >> P;
        prices.push_back(P);
    }

    vector<tuple<int,int,int>> links;
    for(int i = 0; i < M; i++) {
        int V;
        int U;
        int T;
        cin >> V;
        cin >> U;
        cin >> T;
        links.push_back(tuple(V,U,T));
    }

    int A;
    int B;
    cin >> A;
    cin >> B;

    cout << BFS(prices,links,A,B) << endl;
    
    return 0;
}