#include <bits/stdc++.h>
#include <vector>
#include <unordered_map>
using namespace std;

bool contains(vector<long> array, long value) {
    for(long val : array) {
        if(val == value) return true;
    }
    return false;
}

bool checkArraysHaveAtleast1SameValue(vector<long> arr1, vector<long> arr2) {
    unordered_map<long,long> vals;
    for(long val : arr1) {vals[val]++;}
    for(long val : arr2) {vals[val]++;}
    for(const auto& d : vals) {
        if(d.second > 1) return true;
    }
    return false;
}

unordered_map<long,vector<long>> sortGerbsByValAndLords(unordered_map<long,tuple<long,vector<long>>> gerbs) {
    unordered_map<long,vector<long>> d;

    for(const auto& g : gerbs) {
        vector<long> g_d = get<1>(g.second);
        for(int i = 0; i < g_d.size(); i ++) {
            vector<long> *lords = &d[g_d[i]];
            lords->push_back(g.first+1);
        }
    }

    return d;
}

tuple<long,vector<long>> getNearestPath(unordered_map<long,tuple<long,vector<long>>> gerbs, long A, long B) {
    tuple<long,vector<long>> data_a = gerbs[A-1];
    tuple<long,vector<long>> data_b = gerbs[B-1];
    //unordered_map<long,vector<long>> data = sortGerbsByValAndLords(gerbs);
    
    // Check if these have the same gerb
    if(checkArraysHaveAtleast1SameValue(get<1>(data_a),get<1>(data_b))) {
        return tuple(0,vector<long>{0});
    } else {
        // Find a connection
        vector<long> path;
        long current = A-1;
        long prev_val = -1;
        while(true) {
            bool has_s = false;
            for(const auto& gerb : gerbs) {
                if(current == gerb.first) continue;
                vector<long> gerb_arr = get<1>(gerb.second);
                
                for(int i=0; i<gerb_arr.size();i++) {
                    if(gerb_arr[i] == prev_val) gerb_arr[i] = -1;
                }
                vector<long> curr_arr = get<1>(gerbs[current]);
                if(checkArraysHaveAtleast1SameValue(curr_arr, gerb_arr)) {
                    has_s = true;
                    prev_val = current;
                    current = gerb.first;
                    if((current != B-1) && (current != A-1)) path.push_back(current+1);
                    break;
                }
            }
            if(has_s) {
                if(current == B-1) break;
            } else {
                break;
            }
        }
        if(current != B-1) {
            return tuple(-1,vector<long>{0});
        } else {
            return tuple(path.size(),path);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    
    // first line
    long n; // lords count
    cin >> n;

    unordered_map<long,tuple<long,vector<long>>> gerbs;
    for(int i = 0; i < n; i++) {
        long c;
        cin >> c;
        vector<long> g;
        for(int c1 = 0; c1 < c; c1++) {
            long d;
            cin >> d;
            g.push_back(d);
        }
        gerbs[i] = tuple(c,g);
    }
    long A;
    long B;
    cin >> A;
    cin >> B;
    
    tuple<long,vector<long>> data = getNearestPath(gerbs,A,B);
    if(get<0>(data) == 0 || get<0>(data) == -1) {
        cout << get<0>(data) << endl;
    } else {
        cout << get<0>(data) << endl;
        vector<long> arr = get<1>(data);
        for(int i=0; i < arr.size(); i++) {
            cout << arr[i] << " ";
        }
        cout << endl;
    }

    return 0;
}