#include <iostream>
#include <cmath>
#include <vector>
using namespace std;

long long I(long long x, vector<bool> &prime) {
    if (x == 1) return 1;
    if (prime[x]) return x;
    long long n = x;
    while (n % 2 == 0) n /= 2;
    if (n == 1) return 1;
    return 2;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    long long n, q;
    cin >> n >> q;
    vector<bool> prime(n + 1, true);
    prime[1] = false;
    for (long long i = 2; i * i <= n; i++) {
        for (long long j = i + i; j <= n; j += i) {
            prime[j] = false;
        }
    }
    while (q--) {
        long long x;
        cin >> x;
        cout << I(x, prime) << '\n';
    }
}