#include <iostream>
#include <cmath>
#include <vector>
using namespace std;

int I(int x, vector<bool> &prime) {
    if (x == 1) return 1;
    if (prime[x]) return x;
    long long n = x, ans = 1;
    while (n % 2 == 0) {
        n /= 2;
    }
    for (long long i = 3; i <= x; i += 2) {
        long long cnt = 0;
        while (n % i == 0) {
            n /= i;
            cnt++;
        }
        ans *= pow((i - 1), cnt);
        if (ans == 0) {
            return I(ans, prime);
        }
    }
    return I(ans, prime);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, q;
    cin >> n >> q;
    vector<bool> prime(n + 1, true);
    prime[1] = false;
    for (int i = 2; i * i <= n; i++) {
        for (int j = i + i; j <= n; j += i) {
            prime[j] = false;
        }
    }
    while (q--) {
        int x;
        cin >> x;
        cout << I(x, prime) << '\n';
    }
}