#include <bits/stdc++.h>
using namespace std;
using ll = long long;
#define T second
#define A first

vector<ll> cost;
vector<vector<pair<ll, ll> > > g;
vector<bool> used;
vector<ll> mmin;

bool bfs(ll a, ll b) {
    if (a == b)
        return 1;
    queue<ll> q;
    q.push(a);
    used[a] = 1;
    while (!q.empty()) {
        ll v = q.front();
        q.pop();
        for (auto i: g[v]) {
            if (used[i.A])
                continue;
            if (i.A == b)
                return 1;
            q.push(i.A);
            used[i.A] = 1;
        }
    }
    return 0;
}

bool dfs(ll a, ll b) {
    stack<pair<ll, ll> > s;
    s.push({a, -1});
    mmin[a] = 0;
    while (!s.empty()) {
        auto v = s.top();
        s.pop();
        for (auto i: g[v.A]) {
            if (i.T != v.T) {
                if (mmin[i.A] <= mmin[v.A] + cost[i.T])
                    continue;
                s.push({i.A, i.T});
                mmin[i.A] = mmin[v.A] + cost[i.T];
            }
            if (i.T == v.T) {
                if (mmin[i.A] <= mmin[v.A])
                    continue;
                s.push({i.A, i.T});
                mmin[i.A] = mmin[v.A];
            }
        }
    }
    if (mmin[b] < 1e9)
        return 1;
    return 0;
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    ll n, m, k;
    cin >> n >> m >> k;

    cost.resize(k);
    g.resize(n);
    used.resize(n, 0);
    mmin.resize(n, 1e9);

    for (int i = 0; i < k; ++i) {
        ll a;
        cin >> a;
        cost[i] = a;
    }

    for (int i = 0; i < m; ++i) {
        ll a, b, c;
        cin >> a >> b >> c;
        g[a - 1].emplace_back(b - 1, c-1);
        g[b - 1].emplace_back(a - 1, c-1);
    }
    ll a, b;
    cin >> a >> b;
    if (k == 1 && bfs(a - 1, b - 1)) {
        cout << cost[0];
        return 0;
    }
    if (k == 1) {
        cout << -1;
        return 0;
    }

    if (dfs(a - 1, b - 1))
        cout << mmin[b - 1];
    else
        cout << -1;
}
