#include <bits/stdc++.h>
using namespace std;
using ll = long long;
#define F first
#define S second

vector<vector<ll> > gerb;
vector<vector<ll> > g;
vector<bool> used;
vector<ll> len;

int bfs(ll a, ll b) {
    queue<ll> q;
    q.push(a);
    used[a] = true;
    len[a] = 0;
    while (!q.empty()) {
        ll v = q.front();
        q.pop();
        if (v == b) {
            return len[v];
        }
        for (auto i: g[v]) {
            if (!used[i]) {
                used[i] = true;
                len[i] = len[v] + 1;
                q.push(i);
            }
        }
    }
    return 0;
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    ll n;
    cin >> n;
    used.resize(n);
    len.resize(n, -1);

    gerb.resize(n);

    for (ll i = 0; i < n; ++i) {
        ll k;
        cin >> k;
        for (ll j = 0; j < k; ++j) {
            ll gg;
            cin >> gg;
            gerb[gg - 1].push_back(i);
        }
    }

    g.resize(n);
    for (ll i = 0; i < n; ++i) {
        for (ll j = 0; j < gerb[i].size(); ++j) {
            for (int k = 0; k < gerb[i].size(); ++k)
                if (k != j)
                    g[gerb[i][j]].push_back(gerb[i][k]);
        }
    }
    ll a, b;
    cin >> a >> b;
    ll l = bfs(a - 1, b - 1);
    cout << l - 1 << endl;
    vector<pair<ll, ll> > way(n);
    for (int i = 0; i < n; ++i) {
        way[i].F = len[i];
        way[i].S = i + 1;
    }
    sort(way.begin(), way.end(), [](pair<ll, ll> a, pair<ll, ll> b) {
        return a.F < b.F;
    });
    for (int i = 0; i < n; ++i) {
        if (way[i].F >= 0 && way[i].S != a && way[i].S != b)
            cout << way[i].S << " ";
    }
}
