#include <bits/stdc++.h>
using namespace std;

#define int long long

set<pair<int,int> > used;

void dfs(int u, int col, vector<map<int, vector<int> > > &g2, vector<int> &ds) {
    used.insert({col, u});
    for (auto v: g2[u][col]) {
        if (!used.count({col, v})) {
            ds[v] = min(ds[u], ds[v]);
            dfs(v, col, g2, ds);
        }
    }
}

signed main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n, m, k;
    cin >> n >> m >> k;
    vector<int> P(k);
    for (int i = 0; i < k; i++) {
        cin >> P[i];
    }
    vector<vector<pair<int,int> > > g(n);
    vector<map<int, vector<int> > > g2(n);
    for (int i = 0; i < m; i++) {
        int u, v, t;
        cin >> u >> v >> t;
        u--;
        v--;
        t--;
        g[u].push_back({v, t});
        g[v].push_back({u, t});
        g2[u][t].push_back(v);
        g2[v][t].push_back(u);
    }
    int a, b;
    cin >> a >> b;
    a--;
    b--;
    vector<int> ds(n,1e18);
    ds[a] = 0;
    set<tuple<int,int,int> > order;
    order.insert({0, a, -1});
    while (!order.empty()) {
        auto [d, v, type] = *order.begin();
        order.erase(order.begin());
        if (type != -1 && !used.count({type, v})) {
            dfs(v, type, g2, ds);
        }
        for (auto [u,w] : g[v]) {
            if (d + P[w] < ds[u]) {
                order.insert({d + P[w], u, w});
                ds[u] = d + P[w];
            }
        }
    }
    if (ds[b] == 1e18) {
        cout << -1;
    } else {
        cout << ds[b];
    }
}
