#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

const ll INF = 1e18;

struct Segment {
    ll val = INF;

    Segment operator + (const Segment& other) const {
        return Segment(min(this->val, other.val));
    }
};

void buildTree(vector<Segment>& T, vector<ll>& A, int v, int l, int r) {
    if (r - l == 1) {
        T[v].val = A[l];
        return;
    }

    int mid = (l + r) / 2;
    buildTree(T, A, 2 * v + 1, l, mid);
    buildTree(T, A, 2 * v + 2, mid, r);

    T[v] = T[2 * v + 1] + T[2 * v + 2];
}

Segment getSegment(vector<Segment>& T, int lq, int rq, int v, int l, int r) {
    if (lq <= l && r <= rq)
        return T[v];

    if (l >= rq || r <= lq)
        return {};

    int mid = (l + r) / 2;
    return getSegment(T, lq, rq, 2 * v + 1, l, mid) + getSegment(T, lq, rq, 2 * v + 2, mid, r);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);

    int n, q;
    cin >> n >> q;

    vector<ll> A(n);
    for (int i = 0; i < n; i++) {
        cin >> A[i];
    }

    vector<Segment> T(4 * n);
    buildTree(T, A, 0, 0, n);

    map<int, vector<ll>> M;
    while (q--) {
        int l, r, k;
        cin >> l >> r >> k;

        if (!M.contains(k)) {
            M[k].resize(n - k + 2, 0);
            for (int i = 0; i < n - k + 1; i++) {
                M[k][i + 1] = getSegment(T, i, i + k, 0, 0, n).val + M[k][i];
            }
        }

        cout << M[k][r - k + 1] - M[k][l - 1] << "\n";
    }
    return 0;
}