def is_odd_power_prime_factorization(limit):
    """
    Функция строит маску для каждого числа от 2 до limit включительно,
    где 1 означает, что число нечётно-степенное, 0 — наоборот.
    """
    mask = [True] * (limit + 1)  # Все числа изначально считаем потенциально чётно-нечётными
    mask[0], mask[1] = False, False  # 0 и 1 исключаются
    
    for p in range(2, len(mask)):
        if not mask[p]: continue  # пропускаем составные числа
        exp = 1
        current = p
        while current <= limit:
            # Проставляем флаг согласно чётности экспоненты
            if exp & 1 == 0:  # если степень четная, ставим False
                mask[current] = False
            current *= p
            exp += 1
            
    return mask

def find_consecutive_odd_power_numbers(l, r, m):
    """
    Функция ищет первые m подряд идущих нечётно-степенных чисел на отрезке [l; r]
    Возвращает строку с этими числами или "-1"
    """
    odd_mask = is_odd_power_prime_factorization(r)
    
    # Теперь ищем последовательность
    for start in range(l, r - m + 2):
        found = True
        for i in range(start, start + m):
            if not odd_mask[i]:
                found = False
                break
        if found:
            return ' '.join(map(str, range(start, start + m)))
    
    return '-1'

# Чтение входных данных
m = int(input())
l, r = map(int, input().split())

# Запуск поиска
print(find_consecutive_odd_power_numbers(l, r, m))