import math
 
def is_odd_powered(n):
    """Проверяет, является ли число n нечётно-степенным."""
    i = 2
    while i * i <= n:
        count = 0
        # Подсчет количества делений на простой множитель
        while n % i == 0:
            n //= i
            count += 1
        if count > 0 and count % 2 == 0:
            return False
        i += 1
    # Остался последний простой множитель
    if n > 1 and n != 2:
        return True
    else:
        return False
 
# Входные данные
m = int(input())   # Длина искомой последовательности
l, r = map(int, input().split())  # Границы диапазона
 
current_sequence_length = 0
start_position = None
 
for num in range(l, r + 1):
    if is_odd_powered(num):
        current_sequence_length += 1
        if start_position is None:
            start_position = num
    else:
        current_sequence_length = 0
        start_position = None
    
    if current_sequence_length >= m:
        break
 
if current_sequence_length >= m:
    print(*range(start_position, start_position + m))
else:
    print(-1)
    