from typing import List

def diagonal_painting(n: int, m: int, k: int) -> List[int]:
    colors = [0] * k  # Создаем список для подсчета количества клеток каждого цвета
    
    # Обрабатываем случай маленьких значений суммы координат
    for s in range(2, min(n, m) + 2):
        diag_len = min(s - 1, n, m)  # Длина диагонали
        col = (s - 2) % k  # Номер цвета
        colors[col] += diag_len
    
    # Теперь обрабатываем большие значения суммы координат
    for s in range(max(n, m) + 1, n + m):
        diag_len = max(0, min(n, m) - abs(s - (n + m)))  # Длина диагонали
        col = (s - 2) % k  # Номер цвета
        colors[col] += diag_len
    
    return colors


# Чтение входных данных
n, m, k = map(int, input().strip().split())
colors = diagonal_painting(n, m, k)

# Вывод результатов
for color in colors:
    print(color)