def count_cells_by_color(n, m, k):
    from collections import defaultdict
    
    # Массив для хранения количества клеток каждого цвета
    color_count = [0]*k
    
    # Перебираем возможные суммы s от 2 до n+m-1
    for s in range(2, n+m+1):
        # Определяем минимальное значение длины диагонали
        if s <= min(n, m) + 1:
            length = min(s-1, max(m, n))
        else:
            length = max(min(n, m)-abs(s-n-m-1), 0)
        
        # Определяем индекс цвета (нумерация начинается с 1)
        color_idx = ((s-2)%k)
        
        # Увеличиваем счётчик соответствующего цвета
        color_count[color_idx] += length
    
    return color_count

# Чтение входных данных
n, m, k = map(int, input().split())

# Получаем массив количества клеток каждого цвета
result = count_cells_by_color(n, m, k)

# Вывод результата
for cnt in result:
    print(cnt)