import sys
from functools import lru_cache

sys.setrecursionlimit(150000)
MOD = 10 ** 9 + 7

k = 0
r_bin = []


@lru_cache(None)
def dp(i, rem, tight, start):
    if i == len(r_bin):
        return 1 if rem == 0 else 0

    res = 0
    ub = r_bin[i] if tight else 1

    for d in range(ub + 1):
        nt = tight and (d == ub)
        ns = start or (d == 1)

        if not ns:
            res = (res + dp(i + 1, rem, nt, ns)) % MOD
        else:
            res = (res + dp(i + 1, (rem + d) % k, nt, ns)) % MOD

    return res


def main():
    global k, r_bin
    n, k_str = sys.stdin.readline().split()
    k = int(k_str)
    r = sys.stdin.readline().strip()

    if r == "0":
        print(1)
        return

    r_val = int(r)
    r_bin = [int(b) for b in bin(r_val)[2:]]

    if k > len(r_bin):
        print(1)
        return

    result = dp(0, 0, True, False)
    print(result)


if __name__ == "__main__":
    main()
