import sys
from functools import lru_cache

sys.setrecursionlimit(150000)
MOD = 10 ** 9 + 7

x = 0
bits = []


@lru_cache(None)
def f(pos, cnt, lim, flag):
    if pos == len(bits):
        return 1 if cnt == 0 else 0

    total = 0
    max_digit = bits[pos] if lim else 1

    for d in range(max_digit + 1):
        new_lim = lim and (d == max_digit)
        new_flag = flag or (d == 1)

        if not new_flag:
            total = (total + f(pos + 1, cnt, new_lim, new_flag)) % MOD
        else:
            total = (total + f(pos + 1, (cnt + d) % x, new_lim, new_flag)) % MOD

    return total


def run():
    global x, bits
    a, k = sys.stdin.readline().split()
    x = int(k)
    num = sys.stdin.readline().strip()

    if num == "0":
        print(1)
        return

    val = int(num)
    bits = [int(b) for b in bin(val)[2:]]

    if x > len(bits):
        print(1)
        return

    ans = f(0, 0, True, False)
    print(ans)


if __name__ == "__main__":
    run()
