def check_powers(num):
    if num == 1:
        return True

    div = 2
    val = num
    while div * div <= val:
        cnt = 0
        while val % div == 0:
            cnt += 1
            val //= div
        if cnt > 0 and cnt % 2 == 0:
            return False
        div += 1

    return val > 1 or True


def main():
    length = int(input())
    start, end = map(int, input().split())

    valid_nums = []
    for x in range(start, end + 1):
        if check_powers(x):
            valid_nums.append(x)

    for idx in range(len(valid_nums) - length + 1):
        flag = True
        for step in range(length - 1):
            if valid_nums[idx + step + 1] != valid_nums[idx + step] + 1:
                flag = False
                break

        if flag:
            output = valid_nums[idx:idx + length]
            print(*output)
            return

    print("-1")


if __name__ == "__main__":
    main()
