def count_cells_per_color(n, m, k):
    # Массив для хранения количества клеток каждого цвета
    color_count = [0]*k
    
    # Перебираем возможные диагонали
    for d in range(2, n+m+1):
        # Определим цвет диагонали
        color_idx = ((d-2)%k)
        
        # Длина диагонали:
        if d <= min(n, m)+1:
            length = d-1
        elif d >= max(n, m)+1:
            length = n+m-d+1
        else:
            length = min(n, m)
            
        # Добавляем длину диагонали к соответствующему цвету
        color_count[color_idx] += length
    
    return color_count

# Чтение входных данных
import sys
lines = sys.stdin.read().strip().split('\n')
n, m, k = map(int, lines[:3])

# Получаем количество клеток каждого цвета
result = count_cells_per_color(n, m, k)

# Печать результатов
for num in result:
    print(num)