import sys

def solve():
    n = int(input())
    rects = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rects.append((x1, y1, x2, y2))

    if n == 1:
        print("Yes")
        return

    # Проверка на горизонтальную прямую: max_y1 <= min_y2
    min_y2 = min(y2 for x1, y1, x2, y2 in rects)
    max_y1 = max(y1 for x1, y1, x2, y2 in rects)
    if max_y1 <= min_y2:
        print("Yes")
        return

    # Проверка на вертикальную прямую: max_x1 <= min_x2
    min_x2 = min(x2 for x1, y1, x2, y2 in rects)
    max_x1 = max(x1 for x1, y1, x2, y2 in rects)
    if max_x1 <= min_x2:
        print("Yes")
        return

    # Найдём самый левый прямоугольник (min x1) и самый правый (max x2)
    A = min(rects, key=lambda r: r[0])   # левый
    B = max(rects, key=lambda r: r[2])   # правый

    # Проверим две наклонные прямые:
    # 1. Левый верх (A[0], A[3]) -> Правый низ (B[2], B[1])
    # 2. Левый низ (A[0], A[1]) -> Правый верх (B[2], B[3])

    def line_touches_all(rects, x_start, y_start, x_end, y_end):
        # Вычисляем параметры прямой
        if x_end == x_start:
            # вертикальная прямая
            x = x_start
            for x1r, y1r, x2r, y2r in rects:
                if not (x1r <= x <= x2r):
                    return False
            return True

        try:
            slope = (y_end - y_start) / (x_end - x_start)
        except:
            return False

        # Проверяем каждый прямоугольник
        for x1r, y1r, x2r, y2r in rects:
            # Вычисляем значения y на левой и правой границах прямоугольника
            y_at_x1r = y_start + slope * (x1r - x_start)
            y_at_x2r = y_start + slope * (x2r - x_start)

            # Проверяем пересечение с левой границей прямоугольника
            if y1r <= y_at_x1r <= y2r or y1r <= y_at_x2r <= y2r:
                continue

            # Проверяем пересечение с нижней границей: y = y1r
            if slope != 0:
                x_on_y1r = x_start + (y1r - y_start) / slope
                if x1r <= x_on_y1r <= x2r:
                    continue
                x_on_y2r = x_start + (y2r - y_start) / slope
                if x1r <= x_on_y2r <= x2r:
                    continue

            # Не пересекается ни с одной границей
            return False
        return True

    if (line_touches_all(rects, A[0], A[3], B[2], B[1]) or
        line_touches_all(rects, A[0], A[1], B[2], B[3])):
        print("Yes")
        return

    print("No")


def main():
    t = int(input())
    for _ in range(t):
        solve()

if __name__ == '__main__':
    main()