MOD = 10**9 + 7

import sys
sys.set_int_max_str_digits(1000000)

def solve():
    data = input().split()
    n = int(data[0])
    K = int(data[1])
    R_str = input().strip()

    # Особый случай: R = 0
    if R_str == "0":
        print(1)
        return

    # Преобразуем R в целое число
    R = int(R_str)

    # Случай K == 1
    if K == 1:
        print((R + 1) % MOD)
        return

    # Получаем двоичное представление R
    bin_R = bin(R)[2:]
    L = len(bin_R)  # длина в битах

    # Случай: K > L → только x=0 подходит
    if K > L:
        print(1)
        return

    # Оптимизация: если 2*K > L, то возможны только popcount(x) = 0 или popcount(x) = K
    if K > L // 2:
        # Подсчитаем: количество чисел x в [0, R] с popcount(x) == 0 → только 0
        count0 = 1  # x = 0
        # Подсчитаем количество чисел x в [0, R] с popcount(x) == K
        countK = count_numbers_with_popcount_n(bin_R, K)
        result = (count0 + countK) % MOD
        print(result)
        return

    # Общий случай: K <= L//2 и K >= 2
    # Используем DP по битам: dp[mod][tight]
    dp = [[0] * 2 for _ in range(K)]
    dp[0][1] = 1

    for bit_char in bin_R:
        bit = int(bit_char)
        new_dp = [[0] * 2 for _ in range(K)]

        for mod_val in range(K):
            for tight in [0, 1]:
                count = dp[mod_val][tight]
                if count == 0:
                    continue

                # Поставить 0
                new_mod = mod_val
                new_tight = tight and (0 == bit)
                new_dp[new_mod][new_tight] = (new_dp[new_mod][new_tight] + count) % MOD

                # Поставить 1
                if tight:
                    if 1 > bit:
                        continue
                    new_mod = (mod_val + 1) % K
                    new_tight = tight and (1 == bit)
                    new_dp[new_mod][new_tight] = (new_dp[new_mod][new_tight] + count) % MOD
                else:
                    new_mod = (mod_val + 1) % K
                    new_tight = 0
                    new_dp[new_mod][new_tight] = (new_dp[new_mod][new_tight] + count) % MOD

        dp = new_dp

    result = (dp[0][0] + dp[0][1]) % MOD
    print(result)

# Вспомогательная функция: подсчитать числа <= R (в бинарной строке) с ровно target_popcount единицами
def count_numbers_with_popcount_n(bin_str, target_popcount):
    if target_popcount == 0:
        return 1 if int(bin_str) == 0 else 0
    if target_popcount > len(bin_str):
        return 0

    n = len(bin_str)
    # dp[pos][ones][tight]
    from functools import lru_cache

    @lru_cache(maxsize=None)
    def dp(pos, ones, tight):
        if ones > target_popcount:
            return 0
        if pos == n:
            return 1 if ones == target_popcount else 0
        limit = int(bin_str[pos]) if tight else 1
        res = 0
        for d in range(0, limit + 1):
            new_tight = tight and (d == limit)
            new_ones = ones + d
            res = (res + dp(pos + 1, new_ones, new_tight)) % MOD
        return res

    return dp(0, 0, 1) % MOD

solve()