#!/usr/bin/env python3
import sys

def count_magic(x: int) -> int:
    # divisible by 7 or ends with 7
    c1 = x // 7
    # ends with 7: numbers of form 10*t + 7 <= x => t <= (x-7)//10
    if x >= 7:
        c2 = (x - 7) // 10 + 1
    else:
        c2 = 0
    # intersection: multiples of 7 that end with 7
    # 7*k ends with 7 => 7*k %10 ==7 => k%10 ==? since 7 mod10 *k mod10 =7 -> 7k ≡7 => k ≡1 mod10
    # so k = 1 + 10*t; number =7*(1+10*t)=7+70t
    if x >= 7:
        c12 = (x - 7) // 70 + 1
    else:
        c12 = 0
    return c1 + c2 - c12

def kth_magic(k: int) -> int:
    lo, hi = 1, 10**20
    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1
    return lo

def main():
    data = sys.stdin.read().split()
    if not data:
        return
    k = int(data[0])
    print(kth_magic(k))

if __name__ == '__main__':
    main()
