#!/usr/bin/env python3
import sys
import math

def sum_segment(L, R, s0, k, mode, A, total):
    # mode: 'inc', 'const', 'dec'
    # inc: len = s-1
    # const: len = A
    # dec: len = total - (s-1)
    if L>R:
        return 0
    # find first s >=L with (s - s0)%k==0
    if L <= s0:
        s_first = s0
    else:
        diff = L - s0
        s_first = s0 + (diff + k -1)//k * k
    if s_first > R:
        return 0
    # last
    s_last = R - (R - s0)%k
    if s_last < L:
        return 0
    N = (s_last - s_first)//k + 1
    if mode=='inc':
        # sum s-1
        # sum_s = N/2*(s_first + s_last)
        sum_s = N*(s_first + s_last)//2
        return sum_s - N
    elif mode=='const':
        return N * A
    else:
        # dec: total - (s-1)
        # sum len = N*total - (sum of s-1)
        sum_s = N*(s_first + s_last)//2 - N
        return N*total - sum_s

def main():
    data=sys.stdin.read().split()
    if not data: 
        return
    n,m,k=map(int,data)
    A=min(n,m)
    D=max(n,m)
    total = n+m
    res=[0]*k
    for t in range(k):
        s0 = 2 + t
        # segments
        s1_L=2; s1_R=A+1
        s2_L=A+2; s2_R=D+1
        s3_L=D+2; s3_R=total
        s = 0
        s += sum_segment(s1_L, s1_R, s0, k, 'inc', A, total)
        s += sum_segment(s2_L, s2_R, s0, k, 'const', A, total)
        s += sum_segment(s3_L, s3_R, s0, k, 'dec', A, total)
        res[t]=s
    print(*res, sep="\n")

if __name__=='__main__':
    main()
