def is_odd_powered(n):
    """
    Проверяет, является ли число n нечётно-степенным.
    Число n нечётно-степенное, если все его простые делители входят в разложение
    числа n в нечётных степенях.
    """
    if n == 1:  # 1 не имеет простых делителей, поэтому считается нечётно-степенным
        return True

    d = 2
    temp_n = n
    while d * d <= temp_n:
        count = 0
        while temp_n % d == 0:
            count += 1
            temp_n //= d
        if count % 2 == 0 and count > 0:  # Если степень чётная и > 0, то не нечётно-степенное
            return False
        d += 1
    
    if temp_n > 1:  # Если остался простой множитель, его степень 1 (нечётная)
        pass # Это условие выполняется, поэтому ничего не делаем

    return True

def solve():
    m = int(input())
    l, r = map(int, input().split())

    # Предварительно вычислим все нечётно-степенные числа в диапазоне [l, r]
    odd_powered_numbers = []
    for num in range(l, r + 1):
        if is_odd_powered(num):
            odd_powered_numbers.append(num)

    # Ищем последовательность из m подряд идущих нечётно-степенных чисел
    # Проходим по списку нечётно-степенных чисел и проверяем, есть ли m подряд
    for i in range(len(odd_powered_numbers) - m + 1):
        # Проверяем, являются ли числа odd_powered_numbers[i]...odd_powered_numbers[i+m-1]
        # последовательными.
        # Это значит, что разница между каждым соседним числом должна быть 1.
        
        is_consecutive = True
        for j in range(m - 1):
            if odd_powered_numbers[i + j + 1] != odd_powered_numbers[i + j] + 1:
                is_consecutive = False
                break
        
        if is_consecutive:
            # Нашли последовательность. Выводим её.
            # Первое число должно быть наименьшим на отрезке [l;r], что гарантируется
            # тем, что мы ищем именно в этом отрезке.
            result = [odd_powered_numbers[i + j] for j in range(m)]
            print(*result)
            return

    # Если последовательность не найдена
    print("-1")

solve()