import sys

def count_magic_numbers(x):
    """
    Вычисляет количество 'магических чисел' (делящихся на 7 ИЛИ оканчивающихся на 7),
    которые меньше или равны x.
    """
    if x < 0: # Отрицательных чисел в контексте задачи нет
        return 0
    
    # Количество чисел, делящихся на 7
    count_div7 = x // 7

    # Количество чисел, оканчивающихся на 7
    # Формула (x + 3) // 10 корректна для x >= 0
    count_ends7 = (x + 3) // 10

    # Количество чисел, делящихся на 7 И оканчивающихся на 7
    # Эти числа имеют вид 70k + 7.
    # Формула (x + 63) // 70 корректна для x >= 0
    count_both = (x + 63) // 70

    # По принципу включений-исключений:
    # Count(A ИЛИ B) = Count(A) + Count(B) - Count(A И B)
    return count_div7 + count_ends7 - count_both

def solve():
    # Считываем k из стандартного ввода.
    # sys.stdin.readline() используется для более быстрого ввода по сравнению с input()
    k = int(sys.stdin.readline())

    # Бинарный поиск для нахождения k-го магического числа.
    # Минимальное возможное магическое число - 7.
    low = 1 
    # Максимальное возможное k-е магическое число.
    # Плотность магических чисел примерно 16/70, то есть k-е число будет примерно 4.375 * k.
    # Для k = 10^17, это около 4.375 * 10^17.
    # 10^18 является безопасной верхней границей для поиска.
    high = 10**18 

    # Переменная для хранения результата. Инициализируем верхней границей.
    ans = high 

    while low <= high:
        mid = (low + high) // 2
        
        # Вычисляем, сколько магических чисел существует до 'mid' включительно.
        num_magic = count_magic_numbers(mid)

        if num_magic >= k:
            # Если количество магических чисел до 'mid' больше или равно K,
            # то 'mid' может быть нашим ответом, или ответ находится в меньшем диапазоне.
            ans = mid
            high = mid - 1
        else:
            # Если количество магических чисел до 'mid' меньше K,
            # то k-е магическое число находится в большем диапазоне.
            low = mid + 1
            
    # Выводим найденное k-е магическое число.
    # sys.stdout.write() используется для более быстрого вывода по сравнению с print()
    sys.stdout.write(str(ans) + "\n")

# Проверяем, что скрипт запущен напрямую, а не импортирован как модуль.
if __name__ == '__main__':
    solve()