
#include <iostream>
#include <vector>
#include <numeric> 
#include <algorithm> // Для std::min/max/swap

// Функция для включения быстрой работы с вводом/выводом в C++
void fast_io() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

// Вспомогательная функция для вычисления суммы арифметической прогрессии.
// Суммирует значения f(D) для D = first_D_val_in_ap, first_D_val_in_ap + k_val, ..., last_D_val_in_ap.
// f(D) может быть D (для растущего сегмента) или (N_plus_M_val - D) (для убывающего сегмента).
long long calculate_progression_sum(long long first_D_val_in_ap, long long last_D_val_in_ap, 
                                     bool is_rising_segment, long long N_plus_M_val, long long k_val) {
    // Если диапазон пуст (например, first_D_val_in_ap > last_D_val_in_ap), возвращаем 0.
    if (first_D_val_in_ap > last_D_val_in_ap) {
        return 0;
    }
    
    // Количество членов в арифметической прогрессии
    long long num_terms = (last_D_val_in_ap - first_D_val_in_ap) / k_val + 1;
    
    if (is_rising_segment) {
        // Сумма для значений D, D+k, ...
        // Сумма = количество_членов * (первый_член + последний_член) / 2
        return num_terms * (first_D_val_in_ap + last_D_val_in_ap) / 2;
    } else { // Убывающий сегмент, значения (N_plus_M - D), (N_plus_M - (D+k)), ...
        long long first_term_value = N_plus_M_val - first_D_val_in_ap;
        long long last_term_value = N_plus_M_val - last_D_val_in_ap;
        return num_terms * (first_term_value + last_term_value) / 2;
    }
}

int main() {
    fast_io(); // Включаем быструю работу с вводом/выводом

    long long n, m, k;
    std::cin >> n >> m >> k;

    // Инициализируем вектор для хранения количества клеток каждого цвета (0-индексированные цвета)
    std::vector<long long> ans(k, 0);

    // Убедимся, что n <= m для упрощения логики в трех частях (меняем местами, если m < n).
    // Это упрощает определение min_dim (n) и max_dim (m).
    if (n > m) {
        std::swap(n, m);
    }

    long long N_plus_M = n + m; // Сумма n+m, используемая в формуле для убывающего сегмента
    
    // --- Часть 1: Растущие количества (D от 1 до n) ---
    // Здесь количество_клеток(D) = D
    long long segment1_start_D = 1;
    long long segment1_end_D = n;

    if (segment1_start_D <= segment1_end_D) { // Проверяем, не пуст ли сегмент
        for (long long color_idx = 0; color_idx < k; ++color_idx) {
            // Находим первый диагональный индекс D в этом сегменте (>= segment1_start_D),
            // который имеет текущий color_idx (т.е., (D-1)%k == color_idx).
            // Формула: segment_start_D + (целевой_остаток - текущий_остаток + k) % k
            long long current_rem_at_start = (segment1_start_D - 1) % k;
            long long first_D_actual = segment1_start_D + (color_idx - current_rem_at_start + k) % k;

            // Если найденный первый D_actual находится в пределах границ сегмента
            if (first_D_actual <= segment1_end_D) {
                // Находим последний диагональный индекс D в этом сегменте (<= segment1_end_D)
                long long num_multiples_of_k = (segment1_end_D - first_D_actual) / k;
                long long actual_last_D = first_D_actual + num_multiples_of_k * k;
                
                // Добавляем сумму количеств для этого цвета к его общему счету
                ans[color_idx] += calculate_progression_sum(first_D_actual, actual_last_D, true, 0, k); // N_plus_M здесь не используется
            }
        }
    }

    // --- Часть 2: Плоские количества (D от n+1 до m) ---
    // Здесь количество_клеток(D) = n (min_dim)
    long long segment2_start_D = n + 1;
    long long segment2_end_D = m;

    if (segment2_start_D <= segment2_end_D) { // Проверяем, не пуст ли сегмент
        for (long long color_idx = 0; color_idx < k; ++color_idx) {
            long long current_rem_at_start = (segment2_start_D - 1) % k;
            long long first_D_actual = segment2_start_D + (color_idx - current_rem_at_start + k) % k;

            if (first_D_actual <= segment2_end_D) {
                long long num_multiples_of_k = (segment2_end_D - first_D_actual) / k;
                long long actual_last_D = first_D_actual + num_multiples_of_k * k;
                
                // Для этого плоского сегмента каждая клетка в диагонали добавляет 'n' к счету.
                // Следовательно, сумма равна 'n' * количество_членов.
                long long num_terms = (actual_last_D - first_D_actual) / k + 1;
                ans[color_idx] += num_terms * n;
            }
        }
    }

    // --- Часть 3: Убывающие количества (D от m+1 до n+m-1) ---
    // Здесь количество_клеток(D) = n + m - D
    long long segment3_start_D = m + 1;
    long long segment3_end_D = N_plus_M - 1; // Общее количество диагоналей n+m-1

    if (segment3_start_D <= segment3_end_D) { // Проверяем, не пуст ли сегмент
        for (long long color_idx = 0; color_idx < k; ++color_idx) {
            long long current_rem_at_start = (segment3_start_D - 1) % k;
            long long first_D_actual = segment3_start_D + (color_idx - current_rem_at_start + k) % k;
            
            if (first_D_actual <= segment3_end_D) {
                long long num_multiples_of_k = (segment3_end_D - first_D_actual) / k;
                long long actual_last_D = first_D_actual + num_multiples_of_k * k;
                
                // Добавляем сумму количеств для этого цвета (убывающая прогрессия)
                ans[color_idx] += calculate_progression_sum(first_D_actual, actual_last_D, false, N_plus_M, k);
            }
        }
    }

    // Выводим результаты
    for (long long i = 0; i < k; ++i) {
        std::cout << ans[i] << (i == k - 1 ? "" : " ");
    }
    std::cout << "\n";

    return 0;
}
