import sys

def solve():
    n, m, k = map(int, sys.stdin.readline().split())

    # Initialize results array for k colors (0-indexed)
    ans = [0] * k

    # Ensure n <= m for simpler logic in parts (swap if m < n).
    # This simplifies the definition of min_dim (n) and max_dim (m).
    if n > m:
        n, m = m, n
        # Swapping does not affect the final counts per color, only which
        # dimension is considered 'min_dim' and 'max_dim' for the formulas.

    # N_plus_M is used for the falling part's count formula: n + m - D
    N_plus_M = n + m
    
    # Helper function to calculate sum of an arithmetic progression.
    # Sums f(D) for D = actual_first_D, actual_first_D + k, ..., actual_last_D.
    # f(D) can be D (rising) or (N_plus_M_val - D) (falling).
    def calculate_progression_sum(first_D_val_in_ap, last_D_val_in_ap, is_rising_segment, N_plus_M_val):
        # If the range is empty (e.g., first > last), return 0.
        if first_D_val_in_ap > last_D_val_in_ap:
            return 0
        
        num_terms = (last_D_val_in_ap - first_D_val_in_ap) // k + 1
        
        if is_rising_segment:
            # Sum for values D, D+k, ...
            sum_of_values = num_terms * (first_D_val_in_ap + last_D_val_in_ap) // 2
        else: # Falling segment, values are (N_plus_M - D), (N_plus_M - (D+k)), ...
            first_term_value = N_plus_M_val - first_D_val_in_ap
            last_term_value = N_plus_M_val - last_D_val_in_ap
            sum_of_values = num_terms * (first_term_value + last_term_value) // 2
            
        return sum_of_values

    # --- Part 1: Rising counts (D from 1 to n) ---
    # Here, count(D) = D
    segment1_start_D = 1
    segment1_end_D = n # As per n <= m, n is min_dim

    if segment1_start_D <= segment1_end_D: # Check if segment is not empty
        for color_idx in range(k):
            # Find the first diagonal D in this segment (>= segment1_start_D)
            # that has the current color_idx (i.e., (D-1)%k == color_idx).
            first_D_actual = segment1_start_D + (color_idx - (segment1_start_D - 1) % k + k) % k

            # If this starting D is within the segment's end boundary
            if first_D_actual <= segment1_end_D:
                # Find the last diagonal D in this segment (<= segment1_end_D)
                # that has the current color_idx.
                actual_last_D = first_D_actual + ((segment1_end_D - first_D_actual) // k) * k
                                # Add the sum of counts for this color to its total
                ans[color_idx] += calculate_progression_sum(first_D_actual, actual_last_D, True, 0) # N_plus_M not used here

    # --- Part 2: Flat counts (D from n+1 to m) ---
    # Here, count(D) = n (min_dim)
    segment2_start_D = n + 1
    segment2_end_D = m # As per n <= m, m is max_dim

    if segment2_start_D <= segment2_end_D: # Check if segment is not empty
        length_of_flat_part = segment2_end_D - segment2_start_D + 1
        count_val = n # All diagonals in this part have 'n' cells

        # Calculate contributions from full cycles of k diagonals
        num_full_cycles = length_of_flat_part // k
        for color_idx in range(k):
            ans[color_idx] += num_full_cycles * count_val

        # Calculate contributions from remaining diagonals (less than a full cycle of k)
        remaining_diagonals = length_of_flat_part % k
        current_D_for_rem = segment2_start_D + num_full_cycles * k # The D value for the first remaining diagonal
        for i in range(remaining_diagonals):
            # Calculate the 0-indexed color for the current remaining diagonal
            actual_color_idx = (current_D_for_rem + i - 1) % k
            ans[actual_color_idx] += count_val

    # --- Part 3: Falling counts (D from m+1 to n+m-1) ---
    # Here, count(D) = n + m - D
    segment3_start_D = m + 1
    segment3_end_D = n + m - 1 # Total diagonals is n+m-1

    if segment3_start_D <= segment3_end_D: # Check if segment is not empty
        for color_idx in range(k):
            # Find first D for this color in this segment
            first_D_actual = segment3_start_D + (color_idx - (segment3_start_D - 1) % k + k) % k
            
            # If this starting D is within the segment's end boundary
            if first_D_actual <= segment3_end_D:
                # Find the last D for this color in this segment
                actual_last_D = first_D_actual + ((segment3_end_D - first_D_actual) // k) * k
                
                # Add the sum of counts for this color
                ans[color_idx] += calculate_progression_sum(first_D_actual, actual_last_D, False, N_plus_M)

    # Output results (join with spaces)
    sys.stdout.write(' '.join(map(str, ans)) + '\n')

# Call the solve function to run the solution
solve()