# Необходимо использовать sys для более быстрого ввода/вывода в условиях олимпиадного программирования,
# хотя для данной задачи с небольшим объемом ввода/вывода это может быть не критично.
import sys

def solve():
    # Считываем N, M, K из стандартного ввода.
    # input().split() разбивает строку по пробелам, map(int, ...) преобразует части в целые числа.
    n, m, k = map(int, sys.stdin.readline().split())

    # Для упрощения логики работы с сегментами диагоналей,
    # всегда делаем так, чтобы n было меньшим или равным измерением.
    if n > m:
        n, m = m, n

    # Инициализируем список для хранения количества клеток каждого цвета.
    # Длина списка K, все элементы изначально равны 0.
    ans = [0] * k

    # Вспомогательная функция для подсчета клеток в определенном сегменте диагоналей.
    # segment_start_idx: начальный индекс диагонали (включительно)
    # segment_end_idx: конечный индекс диагонали (включительно)
    # get_val_func: функция, которая по индексу диагонали 'idx' возвращает количество клеток на этой диагонали.
    def add_segment_counts(segment_start_idx, segment_end_idx, get_val_func):
        # Если сегмент пуст, нет смысла продолжать
        if segment_start_idx > segment_end_idx:
            return

        # Проходим по каждому цвету от 0 до K-1
        for c in range(k):
            # Находим первый индекс диагонали 'idx' в текущем сегменте,
            # который имеет цвет 'c' (т.е. idx % k == c).
            # Формула: start_idx + (target_rem - current_rem + k) % k
            # (target_rem = c, current_rem = segment_start_idx % k)
            first_idx_for_c = segment_start_idx + (c - (segment_start_idx % k) + k) % k

            # Если первый найденный индекс выходит за пределы сегмента,
            # значит, для этого цвета нет диагоналей в данном сегменте.
            if first_idx_for_c > segment_end_idx:
                continue

            # Находим последний индекс диагонали 'idx' в текущем сегменте,
            # который имеет цвет 'c'.
            # Формула: end_idx - (current_rem - target_rem + k) % k
            # (target_rem = c, current_rem = segment_end_idx % k)
            last_idx_for_c = segment_end_idx - ((segment_end_idx % k) - c + k) % k
            
            # Поскольку first_idx_for_c и last_idx_for_c всегда будут в рамках [segment_start_idx, segment_end_idx]
            # (если first_idx_for_c > segment_end_idx, мы бы уже вышли),