def count_cells_per_color(n, m, k):
    result = [0]*k
    
    # Перебираем каждую строку
    for row in range(min(n, m)):
        # Длина диагонали растет от 1 до min(n, m)
        diagonal_length = row + 1
        
        # Рассчитываем номер цвета, учитывая цикл
        color = ((row % k) + 1) % k
        if color == 0:
            color = k
            
        # Добавляем длину диагонали к соответствующему цвету
        result[color-1] += diagonal_length
    
    # Обрабатываем оставшиеся диагонали
    max_diagonal_len = min(n, m)
    remaining_rows = abs(n-m)
    
    for _ in range(remaining_rows):
        diagonal_length = max_diagonal_len
        
        # Определяем следующий цвет
        color = ((_ % k) + 1) % k
        if color == 0:
            color = k
        
        # Добавляем длину диагонали к соответствующему цвету
        result[color-1] += diagonal_length
    
    return result


# Чтение входных данных
import sys
input_data = sys.stdin.read().strip()
lines = input_data.split('\n')
n, m, k = map(int, lines)

# Вычисление результата
result = count_cells_per_color(n, m, k)

# Печать результатов
for num in result:
  