def is_odd_power(n):
    if n == 1:
        return True
    factors = {}
    for i in range(2, int(n**0.5) + 1):
        while n % i == 0:
            if i in factors:
                factors[i] += 1
            else:
                factors[i] = 1
            n //= i
    if n > 1:
        factors[n] = 1
    return all(exp % 2 == 1 for exp in factors.values())

def generate_odd_power_numbers(l, r):
    odd_power_numbers = []
    for num in range(l, r + 1):
        if is_odd_power(num):
            odd_power_numbers.append(num)
    return odd_power_numbers

def find_sequence(m, l, r):
    odd_power_numbers = generate_odd_power_numbers(l, r)
    for i in range(len(odd_power_numbers) - m + 1):
        if odd_power_numbers[i:i + m] == list(range(odd_power_numbers[i], odd_power_numbers[i + m])):
            return ' '.join(map(str, odd_power_numbers[i:i + m]))
    return '-1'

m = int(input())
l, r = map(int, input().split())
if r / m < l:
    print(-1)
else:
    print(find_sequence(m, l, r))  
