
import sys

# Установка увеличенной глубины рекурсии для Python, если R очень большое
sys.setrecursionlimit(10 ** 5)

MOD = 10**9 + 7

def solve():
    n, k = map(int, sys.stdin.readline().split())
    r_str = sys.stdin.readline().strip()

    # Переводим R в целое число, а затем в двоичную строку
    R = int(r_str)
    if R == 0:
        # Если R=0, то единственное число, которое удовлетворяет 0 <= x <= R, это x=0.
        # popcount(0) = 0. Если 0 % K == 0 (что всегда верно), то ответ 1.
        print(1)
        return

    r_bin = bin(R)[2:]  # Получаем двоичное представление R, убираем "0b"
    len_r_bin = len(r_bin)

    # dp[idx][current_popcount_mod_k][is_less][is_started]
    # idx: текущий обрабатываемый бит
    # current_popcount_mod_k: текущий popcount по модулю K
    # is_less: True, если число уже меньше R_bin на более старших позициях
    # is_started: True, если мы уже поставили хотя бы одну 1 (т.е. не в режиме ведущих нулей)
    memo = {}

    def dp(idx, current_popcount_mod_k, is_less, is_started):
        if idx == len_r_bin:
            return 1 if current_popcount_mod_k == 0 else 0

        state = (idx, current_popcount_mod_k, is_less, is_started)
        if state in memo:
            return memo[state]

        ans = 0
        upper_bound = int(r_bin[idx]) if not is_less else 1

        for digit in range(upper_bound + 1):
            if not is_started and digit == 0:
                # Если мы ещё не начали считать значащие биты и текущая цифра 0,
                # то просто переходим к следующему биту, popcount не меняется.
                ans = (ans + dp(idx + 1, current_popcount_mod_k, is_less or (digit < upper_bound), False)) % MOD
            else:
                # Если мы начали (или текущая цифра 1), то учитываем её
                new_popcount_mod_k = (current_popcount_mod_k + digit) % k
                ans = (ans + dp(idx + 1, new_popcount_mod_k, is_less or (digit < upper_bound), True)) % MOD
        
        memo[state] = ans
        return ans

    # Вызываем dp для числа R
    result_R = dp(0, 0, False, False)

    # Примечание: Для popcount для x=0, popcount(0)=0.
    # Наша DP функция считает числа, которые могут иметь ведущие нули (т.е., по сути, меньшие числа).
    # Но в случае r_bin, оно не имеет ведущих нулей, и "is_started" обрабатывает это.
    # Если мы вызываем dp(0, 0, False, False), то она будет считать числа 0...R.
    # Включая 0.
    # Если R=0, то popcount(0)=0, 0%K=0. Ответ 1.
    # В нашем случае для R=0 мы уже обработали этот случай отдельно.
    # Для R > 0, dp(0,0,False,False) уже включает число 0 и все числа до R.

    print(result_R)

# Запускаем решение
solve()