
import sys

MOD = 10**9 + 7

def solve():
    n, K = map(int, sys.stdin.readline().split())
    R_str = sys.stdin.readline().strip()
    R_bin = bin(int(R_str))[2:]
    len_R_bin = len(R_bin) 
    MAX_BITS = len_R_bin
    C_sum_rem = [[0] * K for _ in range(MAX_BITS + 1)]
    C_sum_rem[0][0] = 1

    for i in range(1, MAX_BITS + 1):
        for j in range(K): 
            prev_j_minus_1 = (j - 1 + K) % K
            C_sum_rem[i][j] = (C_sum_rem[i-1][prev_j_minus_1] + C_sum_rem[i-1][j]) % MOD
    memo = {} 
    def search(idx, pcount_mod_K, is_less):
        state = (idx, pcount_mod_K, is_less)
        if state in memo:
            return memo[state]
        if idx == len_R_bin:
            return 1 if pcount_mod_K == 0 else 0

        ans = 0
        limit_digit = 1
        if not is_less:
            limit_digit = int(R_bin[idx])

        for digit in range(limit_digit + 1):
            new_is_less = is_less or (digit < int(R_bin[idx])) 
            new_pcount_mod_K = (pcount_mod_K + digit) % K
            
            if new_is_less:
                
                remaining_bits = len_R_bin - 1 - idx
                if remaining_bits >= 0:
                    target_rem_for_suffix = (K - new_pcount_mod_K) % K
                    ans = (ans + C_sum_rem[remaining_bits][target_rem_for_suffix]) % MOD
                
            else:
                ans = (ans + search(idx + 1, new_pcount_mod_K, False)) % MOD
                
        memo[state] = ans
        return ans
    final_ans = search(0, 0, False)
    sys.stdout.write(str(final_ans) + '\n')

solve()