import sys

def solve():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX_VAL = r
    is_square_free = [True] * (MAX_VAL + 1)

    if MAX_VAL >= 0:
        is_square_free[0] = False
    limit_for_primes = int(MAX_VAL**0.5) + 1
    
    is_prime = [True] * limit_for_primes
    if limit_for_primes > 0:
        is_prime[0] = False
    if limit_for_primes > 1:
        is_prime[1] = False

    for p in range(2, limit_for_primes):
        if is_prime[p]:
            for multiple in range(p * p, limit_for_primes, p):
                is_prime[multiple] = False
    for p in range(2, limit_for_primes):
        if is_prime[p]: 
            for multiple_of_p_squared in range(p * p, MAX_VAL + 1, p * p):
                is_square_free[multiple_of_p_squared] = False

    consecutive_count = 0
    result_start_index = -1

    for i in range(l, r + 1):
        if is_square_free[i]:
            consecutive_count += 1
            if consecutive_count == m:
                result_start_index = i - m + 1
                break
        else:
            consecutive_count = 0

    if result_start_index != -1:
        output_numbers = [str(num) for num in range(result_start_index, result_start_index + m)]
        sys.stdout.write(" ".join(output_numbers) + "\n")
    else:
        sys.stdout.write("-1\n")
solve()