
import sys

def solve():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX_VAL = r
    primes_sieve = [True] * (MAX_VAL + 1)
    if MAX_VAL >= 0:
        primes_sieve[0] = False
    if MAX_VAL >= 1:
        primes_sieve[1] = False 

    p = 2
    max_p_check = int(MAX_VAL**0.5) + 1 
    while p <= max_p_check:
        if primes_sieve[p]:
            for multiple in range(p * p, MAX_VAL + 1, p):
                primes_sieve[multiple] = False
        p += 1

    
    is_odd_powered = [True] * (MAX_VAL + 1)
    
   
    p = 2
    while p * p <= MAX_VAL: 
        if primes_sieve[p]: 
            for multiple_of_p_squared in range(p * p, MAX_VAL + 1, p * p):
                is_odd_powered[multiple_of_p_squared] = False
        p += 1


    consecutive_count = 0
    result_start_index = -1

    for i in range(l, r + 1):
        if is_odd_powered[i]:
            consecutive_count += 1
            if consecutive_count == m:
                result_start_index = i - m + 1
                break
        else:
            consecutive_count = 0

    if result_start_index != -1:
        output = [str(num) for num in range(result_start_index, result_start_index + m)]
        sys.stdout.write(" ".join(output) + "\n")
    else:
        sys.stdout.write("-1\n")

solve()