
import sys

def solve():
    n = int(sys.stdin.readline())
    m = int(sys.stdin.readline())
    k = int(sys.stdin.readline())

    counts = [0] * k

    if n > m:
        n, m = m, n
    
    
    for color_idx in range(k):

        
        first_s_for_color = color_idx + 2 
        
        if first_s_for_color > n + 1:
            continue
            
        last_s_for_color = first_s_for_color + ((n + 1 - first_s_for_color) // k) * k
        
        num_diagonals_for_color = (last_s_for_color - first_s_for_color) // k + 1
        
        first_term = first_s_for_color - 1
        last_term = last_s_for_color - 1
        
        if num_diagonals_for_color > 0:
            counts[color_idx] += (num_diagonals_for_color * (first_term + last_term)) // 2

   
    if m > n:
        start_s_full = n + 2
        end_s_full = m + 1
        
        total_diagonals_full_phase = end_s_full - start_s_full + 1

        if total_diagonals_full_phase > 0:
            num_cycles = total_diagonals_full_phase // k
            remainder = total_diagonals_full_phase % k
            
            
            initial_color_offset = (start_s_full - 2) % k
            
            for i in range(k):
                counts[(initial_color_offset + i) % k] += num_cycles * n
                
            for i in range(remainder):
                counts[(initial_color_offset + i) % k] += n

    
    for color_idx in range(k):
        
        
        first_s_for_color = m + 2 + (color_idx - ((m + 2 - 2) % k) + k) % k
        
        if first_s_for_color > n + m:
            continue
            
        last_s_for_color = first_s_for_color + ((n + m - first_s_for_color) // k) * k
        
        num_diagonals_for_color = (last_s_for_color - first_s_for_color) // k + 1
        
        first_term = n + m + 1 - first_s_for_color
        last_term = n + m + 1 - last_s_for_color
        
        if num_diagonals_for_color > 0:
            counts[color_idx] += (num_diagonals_for_color * (first_term + last_term)) // 2

    for count in counts:
        sys.stdout.write(str(count) + '\n')

solve()