
import sys

def solve():
    n = int(sys.stdin.readline())
    m = int(sys.stdin.readline())
    k = int(sys.stdin.readline())

    counts = [0] * k

    # Ensure n <= m for simpler logic
    if n > m:
        n, m = m, n
    
    # Define a helper function to add cells for a range of diagonals
    # This function handles full cycles and remaining diagonals within a range
    def add_cells_in_range(start_s, end_s, get_num_cells_func):
        if end_s < start_s:
            return

        total_diagonals = end_s - start_s + 1
        
        # Calculate full cycles of k colors
        num_cycles = total_diagonals // k
        
        # Add cells for full cycles
        for cycle_offset in range(k):
            # Calculate the color index for the diagonal corresponding to this cycle_offset
            # relative to the start_s
            start_s_color = (start_s - 2 + cycle_offset) % k
            # Sum of cells for 'num_cycles' full diagonals of this color
            # We can't simply multiply by num_cells_func because it changes.
            # Instead, we sum the actual cells for 'num_cycles' iterations.
            
            # Since this is a helper, we will just iterate for now for simplicity,
            # but for true big N,M a sum formula is needed.
            # However, for N, M up to 2e9, the total number of diagonals is 4e9,
            # direct iteration is too slow.
            # We need to sum arithmetical progression.

            # For increasing and decreasing parts, the number of cells is an arithmetic progression.
            # For constant part, it's just num_cycles * n.

            pass # This function needs more refined logic depending on the phase.
    
    # Part 1: Increasing number of cells per diagonal (s from 2 to n+1)
    # Number of cells on diagonal S is S-1
    # Example: S=2 (1 cell), S=3 (2 cells), ..., S=n+1 (n cells)
    for s_val in range(2, n + 2):
        color_idx = (s_val - 2) % k
        counts[color_idx] += (s_val - 1)
            
    # Part 2: Constant number of cells per diagonal (s from n+2 to m+1)
    # Number of cells on diagonal S is n
    # This range applies if m > n. If m=n, this part is skipped.
    if m > n:
        start_s_full = n + 2
        end_s_full = m + 1
        total_diagonals_full = end_s_full - start_s_full + 1

        num_cycles = total_diagonals_full // k
        remainder = total_diagonals_full % k
        
        # Determine the starting color index for this segment
        initial_color_offset = (start_s_full - 2) % k
        
        for i in range(k):
            counts[(initial_color_offset + i) % k] += num_cycles * n
            
        # Handle remainder diagonals
        for i in range(remainder):
            counts[(initial_color_offset + i) % k] += n

    # Part 3: Decreasing number of cells per diagonal (s from m+2 to n+m)
    # Number of cells on diagonal S is n + m + 1 - S
    # Example: S=m+2 (n-1 cells), ..., S=n+m (1 cell)
    # This range applies if m > n or if n=m and n > 1.
    for s_val in range(m + 2, n + m + 1):
        color_idx = (s_val - 2) % k
        counts[color_idx] += (n + m + 1 - s_val)

    for count in counts:
        sys.stdout.write(str(count) + '\n')

solve()