def can_light_all_rooms(rooms):
    global_x_min = float('inf')
    global_x_max = float('-inf')
    global_y_min = float('inf')
    global_y_max = float('-inf')
    
    for x1, y1, x2, y2 in rooms:
        global_x_min = min(global_x_min, x1)
        global_x_max = max(global_x_max, x2)
        global_y_min = min(global_y_min, y1)
        global_y_max = max(global_y_max, y2)
    
    # Проверяем пересечение  
    return global_x_min <= global_x_max and global_y_min <= global_y_max

# Чтение входных данных  
import sys  
input = sys.stdin.read  
data = input().splitlines()

index = 0  
T = int(data[index])
index += 1  
results = []

for _ in range(T):
    n = int(data[index])
    index += 1  
    rooms = []
    
    for _ in range(n):
        x1, y1, x2, y2 = map(int, data[index].split())
        rooms.append((x1, y1, x2, y2))
        index += 1
    
    if can_light_all_rooms(rooms):
        results.append("Yes")
    else:
        results.append("No")

# Вывод результатов  
print("\n".join(results))
