def can_light_all_rooms(test_cases):
    results = []
    
    for n, rooms in test_cases:
        max_x1 = -float('inf')
        min_x2 = float('inf')
        max_y1 = -float('inf')
        min_y2 = float('inf')
        
        for (x1, y1, x2, y2) in rooms:
            max_x1 = max(max_x1, x1)
            min_x2 = min(min_x2, x2)
            max_y1 = max(max_y1, y1)
            min_y2 = min(min_y2, y2)

        if max_x1 <= min_x2 and max_y1 <= min_y2:
            results.append("Yes")
        else:
            results.append("No")
    
    return results


def main():
    import sys  
    input = sys.stdin.read

    data = input().strip().splitlines()
    index = 0  
    T = int(data[index])
    index += 1  
    test_cases = []

    for _ in range(T):
        n = int(data[index])
        index += 1  
        rooms = []

        for _ in range(n):
            x1, y1, x2, y2 = map(int, data[index].split())
            rooms.append((x1, y1, x2, y2))
            index += 1
        
        test_cases.append((n, rooms))
    
    results = can_light_all_rooms(test_cases)
    
    for result in results:
        print(result)

if __name__ == "__main__":
    main()
