def count_numbers(pos, count, mod, tight, R_binary, K, memo):
    if pos == len(R_binary):
        return 1 if mod == 0 else 0
    
    if (pos, count, mod, tight) in memo:
        return memo[(pos, count, mod, tight)]
    
    limit = R_binary[pos] if tight else 1  
    result = 0
    
    for digit in range(0, limit + 1):
        result += count_numbers(
            pos + 1,
            count + digit,
            (mod + digit) % K,
            tight and (digit == limit),
            R_binary,
            K,
            memo  
        )

    memo[(pos, count, mod, tight)] = result  
    return result

def main():
    import sys  
    input = sys.stdin.read  
    MOD = 10**9 + 7

    # Чтение входных данных  
    data = input().split()
    n = int(data[0])
    K = int(data[1])
    R = int(data[2])
    
    # Преобразуем R в двоичное представление  
    R_binary = []
    while R > 0:
        R_binary.append(R % 2)
        R //= 2  
    R_binary.reverse()

    # Создаем мемоизацию  
    memo = {}
    
    # Начинаем с позиции 0, 0 единиц, остаток 0 и tight = True  
    result = count_numbers(0, 0, 0, True, R_binary, K, memo) % MOD  
    print(result)

if __name__ == "__main__":
    main()
