def sieve_of_eratosthenes(max_n):
    is_prime = [True] * (max_n + 1)
    is_prime[0] = is_prime[1] = False  
    for start in range(2, int(max_n**0.5) + 1):
        if is_prime[start]:
            for multiple in range(start * start, max_n + 1, start):
                is_prime[multiple] = False  
    return [num for num, prime in enumerate(is_prime) if prime]

def is_odd_powered(n, primes):
    for prime in primes:
        if prime * prime > n:
            break  
        count = 0  
        while n % prime == 0:
            n //= prime  
            count += 1  
        if count % 2 == 0:   
            return False  
    return n == 1 or n % 2 != 0  

def find_odd_powered_sequence(m, l, r):
    primes = sieve_of_eratosthenes(r)
    odd_powered_numbers = []

    for num in range(l, r + 1):
        if is_odd_powered(num, primes):
            odd_powered_numbers.append(num)

    for i in range(len(odd_powered_numbers) - m + 1):
        if odd_powered_numbers[i + m - 1] - odd_powered_numbers[i] == m - 1:
            return odd_powered_numbers[i:i + m]

    return -1

m = int(input())
l, r = map(int, input().split())

result = find_odd_powered_sequence(m, l, r)
if result == -1:
    print(result)
else:
    print(" ".join(map(str, result)))
