def count_magical_numbers(n):
    # Количество чисел, делящихся на 7  
    count_div_7 = n // 7  
    # Количество чисел, заканчивающихся на 7  
    count_ends_7 = (n // 10) + (1 if n % 10 >= 7 else 0)
    # Количество чисел, которые делятся на 7 и заканчиваются на 7  
    count_both = n // 70  # 7 и 70 - наименьшее общее кратное
    
    return count_div_7 + count_ends_7 - count_both

def find_kth_magical_number(k):
    left, right = 1, 10**18  # Начальные границы для бинарного поиска  
    while left < right:
        mid = (left + right) // 2  
        if count_magical_numbers(mid) < k:
            left = mid + 1  
        else:
            right = mid  
    return left

# Чтение входных данных  
k = int(input())
# Получение k-го магического числа  
result = find_kth_magical_number(k)
# Вывод результата  
print(result)
