def is_odd_powered(n):
    """Check if n is odd-powered."""
    factor_count = {}
    
    d = 2  
    while d * d <= n:
        while n % d == 0:
            if d in factor_count:
                factor_count[d] += 1  
            else:
                factor_count[d] = 1  
            n //= d  
        d += 1
    
    if n > 1:  # n is prime  
        factor_count[n] = 1

    for count in factor_count.values():
        if count % 2 == 0:
            return False

    return True

def find_consecutive_odd_powered(m, l, r):
    odd_powered_numbers = []
    
    for num in range(l, r + 1):
        if is_odd_powered(num):
            odd_powered_numbers.append(num)
    
    # Now look for `m` consecutive numbers  
    for i in range(len(odd_powered_numbers) - m + 1):
        if odd_powered_numbers[i + m - 1] - odd_powered_numbers[i] == m - 1:
            return odd_powered_numbers[i:i + m]
    
    return -1

# Input  
m = int(input())
l, r = map(int, input().split())

# Find and print the result  
result = find_consecutive_odd_powered(m, l, r)
if result == -1:
    print(-1)
else:
    print(" ".join(map(str, result)))
