MOD = 10**9 + 7

def str_to_bin(s):
    """Переводит десятичную строку s в двоичную строку."""
    if s == "0":
        return "0"
    digits = list(map(int, s))
    binary = []
    while digits:
        remainder = 0
        new_digits = []
        for d in digits:
            num = remainder * 10 + d
            new_digits.append(num // 2)
            remainder = num % 2
        binary.append(str(remainder))
        # Удаляем ведущие нули
        while new_digits and new_digits[0] == 0:
            new_digits.pop(0)
        digits = new_digits
    return ''.join(reversed(binary))

def solve():
    n, K = map(int, input('Введите числа: ').split())
    R = input('Введите числа: ').strip()

    # Переводим R в двоичную запись
    bin_R = str_to_bin(R)
    m = len(bin_R)  # длина двоичной записи R

    # DP: dp[pos][cnt_ones][tight]
    # cnt_ones: 0..m (максимум m единиц)
    current = [[0] * 2 for _ in range(m + 1)]
    current[0][1] = 1  # начало: 0 единиц, tight=True

    for pos in range(m):
        next_dp = [[0] * 2 for _ in range(m + 1)]
        bit = int(bin_R[pos])


        for cnt_ones in range(m + 1):
            for tight in (0, 1):
                if current[cnt_ones][tight] == 0:
                    continue

                # Максимальная цифра в текущем бите
                max_bit = bit if tight else 1

                for d in (0, 1):
                    if d > max_bit:
                        continue
                    new_tight = 1 if (tight and d == bit) else 0
                    new_cnt = cnt_ones + (1 if d == 1 else 0)
                    if new_cnt <= m:  # защита от выхода за границы
                        next_dp[new_cnt][new_tight] = (
                            next_dp[new_cnt][new_tight] + current[cnt_ones][tight]
                        ) % MOD

        current = next_dp

    # Суммируем состояния, где cnt_ones % K == 0
    result = 0
    for cnt_ones in range(m + 1):
        if cnt_ones % K == 0:
            for tight in (0, 1):
                result = (result + current[cnt_ones][tight]) % MOD


    print(result)

solve()

input()
