def sieve_optimized(n):
    """Решето Эратосфена с bytearray для скорости."""
    is_prime = bytearray([1]) * (n + 1)
    is_prime[0] = is_prime[1] = 0
    for i in range(2, int(n**0.5) + 1):
        if is_prime[i]:
            for j in range(i * i, n + 1, i):
                is_prime[j] = 0
    return [i for i in range(2, n + 1) if is_prime[i]]

def precompute_odd_power(n, primes):
    """Предварительно вычисляем is_odd_power для всех чисел от 2 до n."""
    is_odd_power = [False] * (n + 1)
    
    for x in range(2, n + 1):
        temp = x
        valid = True
        
        for p in primes:
            if p * p > temp:
                break
            if temp % p == 0:
                cnt = 0
                while temp % p == 0:
                    cnt += 1
                    temp //= p
                if cnt % 2 == 0:
                    valid = False
                    break  # Ранний выход при чётной степени
        
        if valid and temp > 1:
            is_odd_power[x] = True
    
    return is_odd_power

# 1. Генерируем простые числа (один раз)
MAX = 10**6
primes = sieve_optimized(MAX)

# 2. Предварительно вычисляем is_odd_power (один раз)
is_odd_power = precompute_odd_power(MAX, primes)

# 3. Ввод данных (через input, но эффективно)
m = int(input('Введите число: '))
l, r = map(int, input('Введите числа: ').split())

# 4. Поиск первой последовательности длины m
found = False
for i in range(l, r - m + 2):
    # Проверяем m чисел подряд с ранним выходом
    for j in range(m):
        if not is_odd_power[i + j]:
            break
    else:
        # Все m чисел подошли
        print(' '.join(map(str, range(i, i + m))))
        found = True
        break

if not found:
    print(-1)

input()
