def count_magic(x):
    """Подсчитывает количество магических чисел <= x."""
    if x < 7:
        return 0
    # Числа, делящиеся на 7
    a = x // 7
    # Числа, оканчивающиеся на 7 (10*t + 7 <= x)
    b = (x - 7) // 10 + 1
    # Числа, делящиеся на 7 И оканчивающиеся на 7 (70*s + 7 <= x)
    c = (x - 7) // 70 + 1
    return a + b - c

def find_kth_magic(k):
    """Находит k-е магическое число с помощью бинарного поиска."""
    left = 1
    right = 7 * k  # Верхний предел для бинарного поиска
    answer = 0
    while left <= right:
        mid = (left + right) // 2
        cnt = count_magic(mid)
        if cnt >= k:
            answer = mid
            right = mid - 1
        else:
            left = mid + 1
    return answer

# === СТРОКА ВВОДА ДАННЫХ ===
k = int(input('Введите число: '))  # <-- ЗДЕСЬ происходит ввод k с клавиатуры (или из файла)

# Вызов функции и вывод результата
print(find_kth_magic(k))

input()
