MOD = 10**9 + 7

# Предподсчёт popcount для цифр 0-9
popcount_digit = [0, 1, 1, 2, 1, 2, 2, 3, 1, 2]

n, K = map(int, input().split())
R = input().strip()

# DP: dp[pos][tight][rem]
dp = [[[0] * K for _ in range(2)] for _ in range(n + 1)]
dp[0][1][0] = 1  # Начало: позиция 0, tight=True, остаток 0

for pos in range(n):
    for tight in range(2):
        for rem in range(K):
            if dp[pos][tight][rem] == 0:
                continue
            # Максимальная цифра, которую можно поставить
            max_digit = int(R[pos]) if tight else 9
            for d in range(max_digit + 1):
                new_tight = 1 if (tight and d == max_digit) else 0
                new_rem = (rem + popcount_digit[d]) % K
                dp[pos + 1][new_tight][new_rem] = (
                    dp[pos + 1][new_tight][new_rem] + dp[pos][tight][rem]
                ) % MOD

# Ответ: сумма всех состояний после обработки всех цифр с rem = 0
answer = (dp[n][0][0] + dp[n][1][0]) % MOD
print(answer)
