MOD = 10 ** 9 + 7


def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    # Переводим R в двоичное представление
    R_bin = bin(int(R))[2:]  # двоичное представление

    length = len(R_bin)

    # DP массив: сохраняем только текущий и следующий слой, чтобы не расходовать много памяти
    # Размер по остаткам: K, по лимитам - 2 (ограничение достигнуто или нет)
    # Инициализация
    from collections import defaultdict

    # current[state] = количество путей
    current = [[[0, 0] for _ in range(K)] for _ in range(length + 1)]
    # Индексы массива:
    # current[i][mod][limit_reached], где:
    # i - текущий бит (обработка с 0 до длина)
    # mod - остаток popcount % K
    # limit_reached - 0 или 1

    # Начинаем с позиции 0, с попкаунтом 0, ограничениями
    current[0][0][1] = 1  # Пока что ограничение соблюдается, мы ещё не выбрали биты

    for i in range(length):
        next_dp = [[[0, 0] for _ in range(K)] for _ in range(length + 1)]
        bit_limit = int(R_bin[i])
        for mod in range(K):
            for limit_reached in range(2):
                ways = current[i][mod][limit_reached]
                if ways == 0:
                    continue
                # Выбираем бит
                for bit in range(2):
                    if limit_reached == 1 or bit <= bit_limit:
                        new_limit_reached = limit_reached
                        if limit_reached == 1:
                            # свободно выбирать бит (0 или 1)
                            pass
                        else:
                            # ограничение по биту R
                            if bit < bit_limit:
                                new_limit_reached = 1
                            # если bit == bit_limit, ограничение остаётся
                        new_mod = (mod + (bit == 1)) % K
                        next_dp[i + 1][new_mod][new_limit_reached] += ways
                        next_dp[i + 1][new_mod][new_limit_reached] %= MOD
        current = next_dp

    # Итог: сумма по состояниям, где попкаунт делится на K (модуль равен 0)
    answer = 0
    for limit_reached in range(2):
        answer += current[length][0][limit_reached]
    answer %= MOD

    print(answer)