import math

def is_odd_power(n):
    if n == 1:
        return False
    temp = n
    for p in range(2, int(math.isqrt(n)) + 1):
        if temp % p == 0:
            cnt = 0
            while temp % p == 0:
                temp //= p
                cnt += 1
            if cnt % 2 == 0:
                return False
    return True

def find_sequence(m, l, r):
    if r - l + 1 < m:
        return -1

    count = 0
    for x in range(l, r + 1):
        if is_odd_power(x):
            count += 1
            if count == m:
                return list(range(x - m + 1, x + 1))
        else:
            count = 0
    return -1

m = int(input())
l, r = map(int, input().split())

result = find_sequence(m, l, r)

if result == -1:
    print(-1)
else:
    print(' '.join(map(str, result)))

