import sys

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n, m, k = map(int, data[:3])
    n, m = int(n), int(m)
    k = int(k)

    ans = [0] * k

    diag_len_min = min(n, m)
    diag_len_max = max(n, m)

    for d in range(1, diag_len_min + 1):
        color = (d - 1) % k
        ans[color] += d
        ans[color] += d

    for d in range(1, diag_len_min + 1):
        color = (d - 1) % k
        ans[color] -= d

    for length in range(diag_len_min + 1, diag_len_max + 1):
        color = (length - 1) % k
        ans[color] += diag_len_min

    for length in range(diag_len_max + 1, n + m):
        color = (length - 1) % k
        start_i = max(1, length - m)
        end_i = min(n, length - 1)
        cnt = end_i - start_i + 1
        ans[color] += cnt

    print("\n".join(map(str, ans)))

if name == "__main__":
    main()
