def is_collinear(p1, p2, p3):
    return (p2[0] - p1[0]) * (p3[1] - p1[1]) == (p3[0] - p1[0]) * (p2[1] - p1[1])
def are_rectangles_aligned(rectangles):

    n = len(rectangles)
    if n <= 2:
        return True

    centers = []
    for x1, y1, x2, y2 in rectangles:
        centers.append(((x1 + x2), (y1 + y2)))

    all_horizontal = all(centers[0][1] == center[1] for center in centers)
    if all_horizontal:
        return True

    all_vertical = all(centers[0][0] == center[0] for center in centers)
    if all_vertical:
        return True

    p1 = centers[0]
    p2 = centers[1]

    return all(is_collinear(p1, p2, center) for center in centers[2:]) if n > 2 else True  # Обрабатываем case when n<=2
def solve():
    """Решает один тестовый случай."""
    n = int(input())
    rectangles = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rectangles.append((x1, y1, x2, y2))

    if are_rectangles_aligned(rectangles):
        print("Yes")
    else:
        print("No")


T = int(input())

for _ in range(T):
    solve()
