def are_rectangles_aligned(rectangles):
    n = len(rectangles)

    if n <= 2:
        return True

    all_horizontal = True
    first_y = (rectangles[0][1] + rectangles[0][3])
    for rect in rectangles:
        current_y = (rect[1] + rect[3])
        if current_y != first_y:
            all_horizontal = False
            break

    if all_horizontal:
        return True

    all_vertical = True
    first_x = (rectangles[0][0] + rectangles[0][2])
    for rect in rectangles:
        current_x = (rect[0] + rect[2])
        if current_x != first_x:
            all_vertical = False
            break

    if all_vertical:
        return True

    x1_center = (rectangles[0][0] + rectangles[0][2])
    y1_center = (rectangles[0][1] + rectangles[0][3])

    x2_center = (rectangles[1][0] + rectangles[1][2])
    y2_center = (rectangles[1][1] + rectangles[1][3])

    if y2_center == y1_center :
      return all((rect[1] + rect[3]) == y1_center for rect in rectangles )
    if x2_center == x1_center:
      return all ((rect[0] + rect[2]) == x1_center for rect in rectangles)


    a = y2_center - y1_center
    b = x1_center - x2_center

    return all((a * (rect[0] + rect[2]) + b * (rect[1] + rect[3])) == 0 for rect in rectangles) 

def solve():
    """
    Решает тестовый случай.
    """
    n = int(input())
    rectangles = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rectangles.append((x1, y1, x2, y2))

    if are_rectangles_aligned(rectangles):
        print("Yes")
    else:
        print("No")
T = int(input())

for _ in range(T):
    solve()
