import sys

def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        
        parts1 = list(map(int, line1.split()))
        if not parts1:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts1 = list(map(int, line1.split()))
        
        if not parts1:
            return

        m = parts1[0]
        
        line2 = sys.stdin.readline()
        if not line2:
            return
        parts2 = list(map(int, line2.split()))
        if not parts2:
            line2 = sys.stdin.readline()
            if not line2:
                return
            parts2 = list(map(int, line2.split()))

        if not parts2:
            return

        l, r = parts2[0], parts2[1]

        # Максимальное значение r по условию 10^6
        # Используем решето для поиска чисел, не делящихся на квадраты простых чисел
        is_square_free = [True] * (r + 1)
        is_square_free[0] = is_square_free[1] = False # Или True в зависимости от определения, но в задаче натуральные числа >= 2
        
        # Решето Эратосфена для поиска квадратов простых чисел
        # Простые числа до sqrt(r_max) = sqrt(10^6) = 1000
        limit = int(r**0.5)
        for i in range(2, limit + 1):
            if is_square_free[i]:
                # Если i - простое, помечаем все числа, делящиеся на i*i
                square_i = i * i
                for j in range(square_i, r + 1, square_i):
                    is_square_free[j] = False
        
        # Поиск последовательности из m чисел
        consecutive_count = 0
        start_num = -1

        for i in range(l, r):
            if is_square_free[i]:
                consecutive_count += 1
                if consecutive_count == m:
                    start_num = i - m + 1
                    break
            else:
                consecutive_count = 0
        
        if start_num != -1:
            result = [str(i) for i in range(start_num, start_num + m)]
            print(" ".join(result))
        else:
            print("-1")

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "main":
    solve()
