def is_odd_power(n):
    if n == 1:
        return True

    d = 2
    while d * d <= n:
        if n % d == 0:
            power = 0
            while n % d == 0:
                n //= d
                power += 1
            if power % 2 == 0:
                return False
        d += 1

    return n <= 1 

def solve():
    m = int(input())
    l, r = map(int, input().split())

    if m > 32:
        print("-1")
        return

    for start in range(l, min(r - m + 2, l + 1000)): 
        valid_sequence = True
        for i in range(start, start + m):
            if not is_odd_power(i):
                valid_sequence = False
                break

        if valid_sequence:
            print(*range(start, start + m))
            return

    print("-1")

solve()

